function plotcdf(fileinfo, reqheight, sizeheight)

% fileinfo contains three columns - file#, #reqs, file size in bytes
% reqheight and sizeheight indicate the y axis values for the
% text fields "requests" and "data size"

MAXLINES = 12;
ourFontName = 'Times';

blocks = 4096*ceil(fileinfo(:,3)/4096);
hits = fileinfo(:,2);

sumhits = sum(hits);
sumblocks = sum(blocks);
normcumhits = cumsum(hits)/sumhits;
normcumblocks = cumsum(blocks)/sumblocks;
x = [1:max(size(hits))]/max(size(hits));

maxy = 1;
height = maxy/MAXLINES;
xi = 0:.001:1;
inormcumhits = interp1(x, normcumhits, xi, 'linear');
inormcumblocks = interp1(x, normcumblocks, xi, 'linear');
% plot(x, normcumhits, x, normcumblocks);
x2 = xi * size(fileinfo,1);
plot(x2, inormcumhits, 'k', x2, inormcumblocks, 'k');

h = axis;
h(2) = size(fileinfo,1);
axis(h);

textstart = .42*size(fileinfo,1);
hstart = .07;
text(textstart, hstart+2*height, sprintf('%.0f requests', sumhits), 'FontName', ourFontName);
text(textstart, hstart+1*height, sprintf('%d files', max(size(hits))), 'FontName', ourFontName);
text(textstart, hstart+0*height, sprintf('%.0f MB total', sumblocks/(1024*1024)), 'FontName', ourFontName);
text(.1*size(fileinfo,1), reqheight, 'requests', 'FontName', ourFontName);
text(.62*size(fileinfo,1), sizeheight, 'data size', 'FontName', ourFontName);
grid on
ylabel('Cumul. reqs, data size (norm.)', 'FontName', ourFontName);
xlabel('File # (sorted by # requests)', 'FontName', ourFontName);
set(gca, 'FontName', ourFontName);
orient tall

